/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.cec;

import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.AuimlDataBeanAdapter;
import com.ibm.hsc.common.util.ErrorPanel;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.websm.bridge.WSessionMgr;
import com.ibm.websm.bundles.CommonBundle;
import com.ibm.websm.console.WWorkingDialog;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.etc.EWorkingListener;
import com.ibm.websm.mobject.MOXContainerObj;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JFrame;

public class ManageOnOffCoDProcessorBean
extends AuimlDataBeanAdapter
implements TaskActionListener {
    private String m_sNumProcInstalled;
    private String m_sNumProcDeconfigured;
    private String m_sNumProcPermInUse;
    private String m_sNumProcImmedInUse;
    private String m_sNumOnOffProcsInUse;
    private String m_sNumOnOffProcsRequested;
    private String m_sNewNumOnOffProcsRequested;
    private double m_dNewProcsRequested;
    private String m_sOnOffCoDProcCapacityCondition;
    private String m_sOnOffProcDaysRemaining;
    private String m_sOnOffProcHoursRemaining;
    private boolean m_bCurrentlyInUse;
    private int m_availableProcs;
    private Object[] m_procArgs = null;
    private Vector m_objVector;
    private int m_immedProcState = 0;
    static /* synthetic */ Class class$com$ibm$websm$etc$EWorkingListener;

    public String getNumOnOffProcsRequested() {
        return this.m_sNumOnOffProcsRequested;
    }

    public void setNumOnOffProcsRequested(String string) throws IllegalUserDataException {
        this.m_sNumOnOffProcsRequested = string;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
        int n = this.getIntValue(this.getNewNumOnOffProcsRequested());
        int n2 = this.getIntValue(this.getNumOnOffProcsInUse());
        int n3 = this.getIntValue(this.getOnOffProcHoursRemaining());
        int n4 = this.getIntValue(this.getOnOffProcDaysRemaining());
        int n5 = n4 + n3 * n2 / 24;
        if (IDebug.enabled) {
            System.err.println("ADC:verifyChanges: Total Days " + n5);
        }
        if (n > n5) {
            String string = HSCResourceBundleUtil.getMessage("CECBundle", "ONOFF_NO_UNCONFIGURED_PROCESSORS_TITLE");
            String string2 = HSCResourceBundleUtil.getMessage("CECBundle", "ONOFF_NO_PROCESSOR_HOURS_LEFT_ERROR");
            ErrorPanel errorPanel = new ErrorPanel(string2, string);
            errorPanel.show();
            throw new IllegalUserDataException();
        }
    }

    public void setMOXContainerObjs(Vector vector) {
        this.m_objVector = vector;
    }

    public void saveArguments(Object[] objectArray) {
        this.m_procArgs = objectArray;
    }

    public void setImmedProcState(int n) {
        this.m_immedProcState = n;
    }

    public void save() {
        int n;
        if (IDebug.enabled) {
            System.err.println("Currently in use is " + this.m_bCurrentlyInUse);
        }
        if (this.m_bCurrentlyInUse) {
            return;
        }
        this.m_bCurrentlyInUse = true;
        MOXContainerObj mOXContainerObj = (MOXContainerObj)this.m_objVector.elementAt(0);
        int n2 = this.getIntValue(this.getNumOnOffProcsInUse());
        int n3 = this.getIntValue(this.getNumOnOffProcsRequested());
        if (n3 == (n = this.getIntValue(this.getNewNumOnOffProcsRequested()))) {
            String string = this.getMessage("ONOFF_NO_PROCESSORS_CHANGED");
            this.m_bCurrentlyInUse = false;
            throw new IllegalUserDataException(string);
        }
        if (n3 < n) {
            if (this.m_availableProcs == 0) {
                String string = HSCResourceBundleUtil.getMessage("CECBundle", "MANAGE_ONOFF_COD_PROCESSORS_DIALOG_ERROR_TITLE");
                String string2 = HSCResourceBundleUtil.getMessage("CECBundle", "ONOFF_PROCS_NOT_AVAILABLE_ERROR", "On/Off Processor state could not be determined");
                ErrorPanel errorPanel = new ErrorPanel(string2, string);
                errorPanel.show();
                throw new IllegalUserDataException();
            }
        } else {
            int n4 = (Integer)mOXContainerObj.getPropertyValue("mode_PROP");
            if ((n4 & 0xFF) == 255) {
                int n5 = this.getUnconfiguredProcessors(mOXContainerObj);
                if (n5 < 0) {
                    if (IDebug.enabled) {
                        System.err.println("Unconfigured processors returned as -1");
                    }
                    this.showError();
                    this.m_bCurrentlyInUse = false;
                    return;
                }
                if (IDebug.enabled) {
                    System.err.println("Unconfigured Procs : " + n5);
                }
                if (n5 < n3 - n) {
                    this.showError();
                    this.m_bCurrentlyInUse = false;
                    return;
                }
            }
        }
        WWorkingDialog wWorkingDialog = new WWorkingDialog((Frame)new JFrame(), CommonBundle.getMessage((String)"WORKING\u001eCommonBundle\u001e"));
        try {
            Object[] objectArray = new Object[5];
            wWorkingDialog.setProperties("e,s");
            wWorkingDialog.showDialog(true);
            EWorkingListener eWorkingListener = (EWorkingListener)WSessionMgr.getProxy((String)(class$com$ibm$websm$etc$EWorkingListener == null ? (class$com$ibm$websm$etc$EWorkingListener = ManageOnOffCoDProcessorBean.class$("com.ibm.websm.etc.EWorkingListener")) : class$com$ibm$websm$etc$EWorkingListener).getName(), (Object)wWorkingDialog);
            objectArray[0] = this.m_procArgs[0];
            objectArray[1] = new Integer(n);
            objectArray[2] = this.m_procArgs[1];
            objectArray[3] = this.m_procArgs[2];
            objectArray[4] = eWorkingListener;
            if (IDebug.enabled) {
                System.err.println("Arguments are: ");
                int n6 = 0;
                while (n6 < objectArray.length) {
                    System.err.println(" Arg " + n6 + " -- " + objectArray[n6]);
                    ++n6;
                }
            }
            mOXContainerObj.getMObject().invokeMethod("manageOnOffCoDProcessors", objectArray);
        }
        catch (Throwable throwable) {
            if (IDebug.enabled) {
                throwable.printStackTrace();
            }
            wWorkingDialog.showDialog(false);
            this.m_bCurrentlyInUse = false;
            throw new IllegalUserDataException(throwable.getMessage());
        }
        this.m_bCurrentlyInUse = false;
        wWorkingDialog.showDialog(false);
    }

    public String getNumProcInstalled() {
        return this.m_sNumProcInstalled;
    }

    public void setNumProcInstalled(String string) throws IllegalUserDataException {
        this.m_sNumProcInstalled = string;
    }

    public String getNumProcDeconfigured() {
        return this.m_sNumProcDeconfigured;
    }

    public void setNumProcDeconfigured(String string) throws IllegalUserDataException {
        this.m_sNumProcDeconfigured = string;
    }

    public String getNumProcPermInUse() {
        return this.m_sNumProcPermInUse;
    }

    public void setNumProcPermInUse(String string) throws IllegalUserDataException {
        this.m_sNumProcPermInUse = string;
    }

    public String getNewNumOnOffProcsRequested() {
        return this.m_sNewNumOnOffProcsRequested;
    }

    public void setNewNumOnOffProcsRequested(String string) throws IllegalUserDataException {
        this.m_sNewNumOnOffProcsRequested = string;
    }

    public String getNumOnOffProcsInUse() {
        return this.m_sNumOnOffProcsInUse;
    }

    public void setNumOnOffProcsInUse(String string) throws IllegalUserDataException {
        this.m_sNumOnOffProcsInUse = string;
    }

    public String getNumProcImmedInUse() {
        return this.m_sNumProcImmedInUse;
    }

    public void setNumProcImmedInUse(String string) throws IllegalUserDataException {
        this.m_sNumProcImmedInUse = string;
    }

    public double getNewProcsRequested() {
        return this.m_dNewProcsRequested;
    }

    public void setNewProcsRequested(double d) throws IllegalUserDataException {
        int n;
        int n2;
        int n3 = (int)d;
        int n4 = Integer.parseInt(this.m_sNumProcInstalled);
        if (n3 > n4 - (n2 = Integer.parseInt(this.m_sNumProcDeconfigured)) - (n = Integer.parseInt(this.m_sNumProcPermInUse))) {
            if (IDebug.enabled) {
                System.err.println(" totalInstalled " + n4);
                System.err.println(" totalDeconfProc " + n2);
                System.err.println(" totalPermInUse " + n);
            }
            String string = this.getMessage("ONOFF_PROCS_EXCEEDS_AVAILABLE_ERROR");
            throw new IllegalUserDataException(string);
        }
        this.m_dNewProcsRequested = d;
        this.setNewNumOnOffProcsRequested((int)d + "");
    }

    public String getOnOffCoDProcCapacityCondition() {
        return this.m_sOnOffCoDProcCapacityCondition;
    }

    public void setOnOffCoDProcCapacityCondition(String string) throws IllegalUserDataException {
        this.m_sOnOffCoDProcCapacityCondition = string;
    }

    public String getOnOffProcDaysRemaining() {
        return this.m_sOnOffProcDaysRemaining;
    }

    public void setOnOffProcDaysRemaining(String string) throws IllegalUserDataException {
        this.m_sOnOffProcDaysRemaining = string;
    }

    public String getOnOffProcHoursRemaining() {
        return this.m_sOnOffProcHoursRemaining;
    }

    public void setOnOffProcHoursRemaining(String string) throws IllegalUserDataException {
        this.m_sOnOffProcHoursRemaining = string;
    }

    public void load() {
        this.m_sNumProcInstalled = "";
        this.m_sNumProcDeconfigured = "";
        this.m_sNumProcPermInUse = "";
        this.m_sNewNumOnOffProcsRequested = "";
        this.m_sNumOnOffProcsInUse = "";
        this.m_sNumProcImmedInUse = "";
        this.m_dNewProcsRequested = 0.0;
        this.m_sOnOffCoDProcCapacityCondition = "";
        this.m_sOnOffProcDaysRemaining = "";
        this.m_sOnOffProcHoursRemaining = "";
        this.m_sNumOnOffProcsRequested = "";
        this.m_bCurrentlyInUse = false;
        this.m_availableProcs = 0;
    }

    private int getIntValue(String string) {
        int n;
        block2: {
            n = -1;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (!IDebug.enabled) break block2;
                System.err.println("Invalid value of String - " + string);
                Thread.currentThread();
                Thread.dumpStack();
            }
        }
        return n;
    }

    private String getMessage(String string) {
        return HSCResourceBundleUtil.getMessage("CECBundle", string);
    }

    private int getUnconfiguredProcessors(MOXContainerObj mOXContainerObj) {
        int n = -1;
        try {
            Short s = (Short)mOXContainerObj.getMOClass().invokeStaticMethod("getFreeCPUs", this.m_procArgs);
            n = s.shortValue();
        }
        catch (Throwable throwable) {
            if (IDebug.enabled) {
                throwable.printStackTrace();
            }
            return n;
        }
        return n;
    }

    public void actionPerformed(TaskActionEvent taskActionEvent) {
        UserTaskManager userTaskManager = this.getUTM();
        if (userTaskManager == null) {
            userTaskManager = (UserTaskManager)taskActionEvent.getSource();
        }
        if (userTaskManager != null) {
            userTaskManager.refreshElement("ProcTCODWizardPanel2.NumProcRequestedNewString");
            userTaskManager.refreshElement("ProcTCODWizardPanel2.NumProcOnOffInUseNewString");
        }
    }

    private void showError() {
        String string = this.getMessage("ONOFF_NO_UNCONFIGURED_PROCESSORS");
        String string2 = this.getMessage("ONOFF_NO_UNCONFIGURED_PROCESSORS_TITLE");
        new ErrorPanel(string, string2).show();
    }

    public void setAvailableProcs(int n) {
        this.m_availableProcs = n;
    }

    public int getAvailableProcs() {
        return this.m_availableProcs;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

